# -*- coding: utf-8 -*-
"""
Created on Mon Jun 18 17:07:21 2012

@author: Timothy.Wiseman

Another Example regarding the toolbar at 
http://stackoverflow.com/questions/10342078/adding-a-toolbar-to-a-mpl-figure-in-pyqt4
from HYRY

Another example of embedding MatPlotLib in PyQt available at:
    

A related example for the MPL Canvas is available at:



Execute this against the SQL Server installation for setup:
create database TestDb
Go
use TestDb
Go
create table SalesData(SalesPerson varchar(100), mon int, amount money)
GO
--Uses a table value constructor from 2008 or later
insert into dbo.SalesData 
	(SalesPerson, mon, amount)
values 
	('Jack', 1, 202.55),
	('Jack', 2, 301.77),
	('Jack', 3, 403.88),
      ('Jack', 4, 400.11),
	('Jill', 1, 410.11),
	('Jill', 2, 305.99),
	('Jill', 3, 412.99),
      ('Jill', 4, 412.99);
"""


############################################################################
#Classes for the Gui


#PyQt4 and matplotlib do not come with the code distribution of python,
#but the come with some more complete Distributions like 
#Python(X,Y), or they can be downloaded separately.
from PyQt4 import QtGui, QtCore
from matplotlib.backends.backend_qt4agg import (FigureCanvasQTAgg, 
                        NavigationToolbar2QT)
from matplotlib.figure import Figure


class mplCanvasWidget(FigureCanvasQTAgg):
    """A QWidget that provides the canvas to be placed in the Gui.
    Variations on this are included with PythonXY."""
    
    def __init__(self, parent =None, x=[0, ], y=[0, ]):
        mplFig = Figure()
        self.axes = mplFig.add_subplot(1, 1, 1)
        #self.axes.hold(False) #ensures it will be cleared when plot is called
        self.plot(x, y)
        FigureCanvasQTAgg.__init__(self, mplFig)
        
        self.setParent(parent) #inherited as a QWidget
        
        FigureCanvasQTAgg.setSizePolicy(self, QtGui.QSizePolicy.Expanding,
                                        QtGui.QSizePolicy.Expanding)
        FigureCanvasQTAgg.updateGeometry(self)
        
    def plot(self, x, y):
        """plots the x and y lists passed in, will overwite any data 
        already there."""
        self.axes.clear()
        self.axes.plot(x, y)


      
import pyodbc
        
class guiWindow(QtGui.QMainWindow):
    """Often this would be created by a tool like QT Designer"""
    def __init__(self, sqlConn):
        QtGui.QMainWindow.__init__(self)
        
        #Bring the sqlConnection into the namespace
        self.sqlConn = sqlConn

        #Create the Widgets        
        self.coreWidget = QtGui.QWidget(self) #This holds all the others
        #salesPersonChoice options will be populated later, just create now
        self.salesPersonChoice = QtGui.QComboBox(parent = self.coreWidget)
        self.pyPlot = mplCanvasWidget(parent = self.coreWidget)
        
        #define the toolbar.  This allows the user to zoom in on the 
        #graph, save the graph, etc.
        self.mpl_toolbar = NavigationToolbar2QT(canvas=self.pyPlot, 
                                                parent=self.coreWidget)
        
        #lay out the widgets defined        
        #All other widgets will exist inside the QVBoxLayout
        layout = QtGui.QVBoxLayout(self.coreWidget)
        layout.addWidget(self.salesPersonChoice)
        layout.addWidget(self.pyPlot)
        layout.addWidget(self.mpl_toolbar)
                
        #Connect Signals and Slots
        #QT uses Signals and slots to interconnect the widgets and call actions                
        QtCore.QObject.connect(self.salesPersonChoice, #object that emits
                        QtCore.SIGNAL('activated(const QString&)'), #Signal
                        self.updatePlot) #action to be taken
                
        #now prepare for display
        self.salesPersonChoice.addItems(self.getSalesPeople())
        
        self.coreWidget.setFocus()
        self.setCentralWidget(self.coreWidget)
        
    def getSalesPeople(self):
        salesPeopleList=['',] #start with a blank one so the user can choose
        curs = self.sqlConn.cursor()
        sql = "select distinct SalesPerson from dbo.SalesData"
        curs.execute(sql)
        for row in curs:
            salesPeopleList.append(row.SalesPerson)
        curs.close()
        return QtCore.QStringList(salesPeopleList)
        
    def updatePlot(self):
        """Updates the plot with the data for the selected salesperson"""
        curs = sqlConn.cursor()
        person = str(self.salesPersonChoice.currentText())
        #Parameterized with ?
        sql = """select mon, amount
                from dbo.SalesData
                where SalesPerson = ?
                order by mon"""
        curs.execute(sql, (person,) )
        rows = curs.fetchall()
        x = [row.mon for row in rows]
        y = [row.amount for row in rows]
        self.pyPlot.plot(x, y)
        self.pyPlot.draw()
        
        
###########################################################################
#MainLoop

#Create the SQLConnection

#Adjust for your SQL Server instance.  Here is the one for the primary
#instance with a trusted connection
#sqlConnStr = ('DRIVER={SQL Server};Server=(local);Database=TestDb;'+
#            'Trusted_Connection=YES')
#And here is for my test install of 2012

sqlConnStr = ('DRIVER={SQL Server};Server=TimWiseman-PC\SQLExpress12;'+
                'Database=TestDb;Trusted_Connection=YES')

sqlConn = pyodbc.connect(sqlConnStr)

import sys #used for argv and exec_

app = QtGui.QApplication(sys.argv)
appGui = guiWindow(sqlConn)
appGui.show()
sys.exit(app.exec_())
