/******************************************************
 *
 * Name:         calculate-prime-numbers.sql
 *     
 * Design Phase:
 *     Author:   John Miner
 *     Date:     01-01-2024
 *     Purpose:  Calculate & store prime numbers.
 *     Notes:    Updated for postgreSQL database.
 * 
 ******************************************************/


do $$
  declare var_id bigint;
  declare var_alpha bigint;
  declare var_omega bigint;
	
begin

  -- add new search record
  insert into "dbo"."tbl_control_card" ( "my_id", "my_comment", "my_date" )
  values (default, 'Look for prime numbers.', default)
  returning "my_id" into var_id;

  -- find start/end points
  var_alpha = var_id - 250000;
  var_omega = var_id - 1;
  
  -- write message
  raise notice 'store primes numbers (%, %)', var_alpha, var_omega;
  
  -- find primes (alpha to omega)
  call "dbo"."usp_store_primes" (var_alpha, var_omega);

end; $$;
