/******************************************************
 *
 * Name:         make-prime-number-database.sql
 *     
 * Design Phase:
 *     Author:   John Miner
 *     Date:     01-01-2024
 *     Purpose:  Calculate & store prime numbers.
 *     Notes:    Updated for postgreSQL database.
 * 
 ******************************************************/


/*  
	Create a database
*/

-- who am i?  should by postgres
select current_user;

-- delete existing database
drop database if exists "math";

-- add new database
create database "math" owner "postgres";

-- must re-connect query tool!



/*  
	Create dbo schema, postgres's default is public
*/

-- drop existing schema
drop schema if exists "dbo" cascade;

-- create new schema
create schema "dbo";



/*  
	Create a table to hold the prime numbers
*/

-- delete existing table
drop table if exists "dbo"."tbl_primes";

-- add new table
create table "dbo"."tbl_primes"
(
  "my_value" bigint not null,
  "my_division" bigint not null constraint "chk_tbl_primes" check ("my_division" > 0),
  "my_time" timestamp not null constraint "df_tbl_primes" default (current_timestamp),
  constraint "pk_tbl_primes" primary key ("my_value")
);



/*  
	Create a sequnce for the job card table
*/

-- drop existing sequence
drop sequence if exists "dbo"."seq_control_card_id";

-- add new sequnce
create sequence "dbo"."seq_control_card_id" increment 250000 start 1;



/*  
	Create a table to hold the job control card
*/

-- delete existing table
drop table if exists "dbo"."tbl_control_card";

-- add new table
create table "dbo"."tbl_control_card"
(
	"my_id" bigint default(nextval('dbo.seq_control_card_id')),
	"my_comment" varchar (128),
	"my_date" timestamp default (current_timestamp)
);


-- add first record
insert into "dbo"."tbl_control_card" values (default, 'Starting Point', default);

-- show data
select * from "dbo"."tbl_control_card";



/*  
	Create a function to determine if number is prime
*/

-- delete existing function
drop function if exists "dbo"."ufn_is_prime";

-- create new function
create function "dbo"."ufn_is_prime" 
(
	var_num2 bigint = 1,
    var_cnt2 bigint = 0, 
	var_max2 bigint = 0
)
returns integer as $$
begin

    -- not a prime number
    if (var_num2 = 1) then
	  return 0;
	end if;

    -- is a prime number
    if (var_num2 = 2) then
	  return 1;
	end if;

    -- set up counters   
    var_cnt2 := 2;
    var_max2 := floor(sqrt(var_num2)) + 1;
	
    -- trial divison
    while (var_cnt2 <= var_max2) 
	loop
    
	    -- debugging
   	    -- raise notice 'test division - (num, cnt, max) - (% , %, %)', var_num2, var_cnt2, var_max2;

        -- not a prime number
        if (var_num2 % var_cnt2) = 0 then
	      return 0;
	    end if;
		
		-- increment counter
	    var_cnt2 := var_cnt2 + 1;
		
    end loop;

    -- is a prime number
    return 1;

end 
$$ language plpgsql;



/*  
	Validate function
*/

/*
select 1 as candidate, "dbo"."ufn_is_prime"(1) as is_prime
union 
select 2, "dbo"."ufn_is_prime"(2)
union 
select 3, "dbo"."ufn_is_prime"(3)
union 
select 4, "dbo"."ufn_is_prime"(4)
union 
select 5, "dbo"."ufn_is_prime"(5)
union 
select 6, "dbo"."ufn_is_prime"(6)
union 
select 7, "dbo"."ufn_is_prime"(7)
union 
select 8, "dbo"."ufn_is_prime"(8)
union 
select 9, "dbo"."ufn_is_prime"(9)
union 
select 10, "dbo"."ufn_is_prime"(10)
union 
select 11, "dbo"."ufn_is_prime"(11)
union 
select 12, "dbo"."ufn_is_prime"(12)
union 
select 13, "dbo"."ufn_is_prime"(13)
order by 1;
*/


/*    
	Create a procedure to store primes from x to y.
*/

-- delete existing function
drop procedure if exists "dbo"."usp_store_primes";

-- create new function
create procedure "dbo"."usp_store_primes" 
(
	var_alpha bigint = 1,
    var_omega bigint = 1,
	var_cnt1 bigint = 1,
	var_ret1 integer = 0
)
as $$
begin
 
    -- set starting point
    var_cnt1 := var_alpha;
	
    -- trial divison
    while (var_cnt1 <= var_omega) 
	loop
    
        -- test current number
        select * into var_ret1 from "dbo"."ufn_is_prime"(var_cnt1);

	    -- debugging
   	    -- raise notice 'store primes - (number, prime) - (% , %)', var_cnt1, var_ret1;

        -- is a prime number
        if (var_ret1 = 1) then
            insert into "dbo"."tbl_primes" values (var_cnt1, floor(sqrt(var_cnt1)) + 1, default);
	    end if;
		
		-- increment counter
	    var_cnt1 := var_cnt1 + 1;
		
    end loop;

end 
$$ language plpgsql;



/*    
    Test stored procedure
*/

-- find primes (1 to 21)
-- call "dbo"."usp_store_primes" (1, 21);

-- show results
-- select * from dbo.tbl_primes;



/*    
	Create a view for processing time
*/

-- delete existing function
drop view if exists "dbo"."uvw_processing_time";

-- create new function
create view "dbo"."uvw_processing_time" 
as 
select
	min(p."my_time") as "start_time", 
	max(p."my_time") as "end_time", 
	extract(seconds from (max(p."my_time") - min(p."my_time"))) as "elapsed_time",
	count(*) as "total_recs"
from "dbo"."tbl_primes" as p;

-- show results
-- select * from dbo.uvw_processing_time;



/*    
    Show database objects
*/

select t.table_catalog as user_catalog, t.table_schema as user_schema, t.table_name as object_name, lower(t.table_type) as object_type
from information_schema.tables as t
where table_schema = 'dbo'

union 

select s.sequence_catalog, s.sequence_schema, s.sequence_name, s.data_type
from information_schema.sequences as s
where s.sequence_schema = 'dbo'

union

select r.routine_catalog, r.routine_schema, r.routine_name, lower(r.routine_type)
from information_schema.routines as r
where r.specific_schema='dbo'

order by 4, 3;





/*
    Reset test
*/

truncate table "dbo"."tbl_control_card";
truncate table "dbo"."tbl_primes";
alter sequence dbo.seq_control_card_id restart with 1;
insert into "dbo"."tbl_control_card" values (default, 'Starting Point', default);
